/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspFileOpenResponse;
import com.ibm.hsc.fsp.cmdhelpers.FspLocationCodeInfo;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspLocationCodeList {
    private int LOC_FILE_ID = 10;
    private ArrayList m_locList;
    private UnsignedInt32 m_fileId;
    private FSPCmdMgr m_cmdMgr;
    private byte[] m_data;
    private FspCmdHelper m_cmdHelper;
    private static final String TRACE_MASKT = "JHWSFCNT";
    private int HEADER_SIZE = 12;

    public FspLocationCodeList(UnsignedInt32 unsignedInt32, FSPCmdMgr fSPCmdMgr) {
        this.m_fileId = unsignedInt32;
        this.m_locList = new ArrayList();
        this.m_cmdMgr = fSPCmdMgr;
        this.m_cmdHelper = new FspCmdHelper(this.m_cmdMgr);
    }

    public Iterator getLocCodeList() throws PIHscCmdMgrException {
        Trace.trace(TRACE_MASKT, "-> FspLocationCodeList.getLocCodeList");
        try {
            FspFileOpenResponse fspFileOpenResponse = this.m_cmdHelper.openFileForRead(this.LOC_FILE_ID, this.m_fileId.longValue());
            long l = fspFileOpenResponse.getFileSize();
            this.m_data = this.m_cmdHelper.readFile(this.LOC_FILE_ID, this.m_fileId.longValue(), 0L, l);
            this.m_cmdHelper.closeFile(this.LOC_FILE_ID, this.m_fileId.longValue(), 128L);
        }
        catch (PIHscServerException pIHscServerException) {
            pIHscServerException.printStackTrace();
        }
        this._processFile();
        Trace.trace(TRACE_MASKT, "<- FspLocationCodeList.getLocCodeList()");
        if (this.m_locList.size() == 0) {
            return null;
        }
        return this.m_locList.iterator();
    }

    private void _processFile() throws PIHscCmdMgrException {
        Trace.trace(TRACE_MASKT, "-> FspLocationCodeList._processFile()");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_data);
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2];
        byteArrayInputStream.read(byArray, 0, 4);
        int n = ByteUtilities.byteArrayToInt(byArray);
        byteArrayInputStream.read(byArray2, 0, 2);
        short s = ByteUtilities.byteArrayToShort(byArray2);
        byteArrayInputStream.read(byArray2, 0, 2);
        BitSet bitSet = ByteUtilities.byteArrayToBitSet(byArray2);
        if (n == s) {
            this.m_locList = new ArrayList(0);
            return;
        }
        int n2 = n - s;
        byte[] byArray3 = new byte[n2];
        byteArrayInputStream.read(byArray3, 0, n2);
        this._processStructures(byArray3);
        Trace.trace(TRACE_MASKT, "<- FspLocationCodeList._processFile()");
    }

    private void _processStructures(byte[] byArray) {
        Trace.trace(TRACE_MASKT, "-> FspLocationCodeList._processStructures()");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = new byte[1];
        boolean bl = false;
        String string = null;
        int n = byteArrayInputStream.available();
        boolean bl2 = false;
        boolean bl3 = false;
        while (byteArrayInputStream.available() > 0) {
            try {
                int n2;
                bl3 = false;
                FspLocationCodeInfo fspLocationCodeInfo = new FspLocationCodeInfo();
                byteArrayInputStream.read(byArray3, 0, 2);
                short s = ByteUtilities.byteArrayToShort(byArray3);
                s = (short)(s - 2);
                byte[] byArray5 = new byte[s];
                byteArrayInputStream.read(byArray5, 0, s);
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray5);
                byteArrayInputStream2.read(byArray2, 0, 4);
                if (byArray2[0] == 0) {
                    for (int i = 0; i < byArray2.length; ++i) {
                        byArray2[i] = 32;
                    }
                }
                try {
                    string = new String(byArray2, "US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Trace.trace(TRACE_MASKT, "FspLocationCodeList.processStructures>> Invalid FRU ");
                    for (n2 = 0; n2 < byArray2.length; ++n2) {
                        Trace.trace(TRACE_MASKT, "ccinBytes[" + n2 + "] = " + byArray2[n2]);
                    }
                    string = new String("");
                    HSCLogUtils.serverLog(unsupportedEncodingException, HSCLogUtils._CECClassLogInfo);
                    bl3 = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (string == null) {
                    string = "";
                }
                fspLocationCodeInfo.setCCIN(string);
                string = null;
                int n3 = byteArrayInputStream2.read();
                fspLocationCodeInfo.setStatus(new UnsignedInt8((short)n3));
                n3 = byteArrayInputStream2.read();
                fspLocationCodeInfo.setState(new UnsignedInt8((short)n3));
                int n4 = byteArrayInputStream2.read();
                int n5 = byteArrayInputStream2.read();
                byte[] byArray6 = new byte[n4];
                byteArrayInputStream2.read(byArray6, 0, n4);
                try {
                    fspLocationCodeInfo.setLocationCode(new String(byArray6, "US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Trace.trace(TRACE_MASKT, "!!!! FspLocationCodeList.processStructures !!!! Invalid Location Code ");
                    for (n2 = 0; n2 < byArray6.length; ++n2) {
                        Trace.trace(TRACE_MASKT, "locCodeBytes[" + n2 + "] = " + byArray6[n2]);
                    }
                    HSCLogUtils.serverLog(unsupportedEncodingException, HSCLogUtils._CECClassLogInfo);
                    fspLocationCodeInfo.setLocationCode(new String(""));
                    bl3 = true;
                    unsupportedEncodingException.printStackTrace();
                }
                this.m_locList.add(fspLocationCodeInfo);
                if (!bl3) continue;
                Trace.trace(TRACE_MASKT, "!!! FspLocationCodeList.processStructures !!! Invalid entries ");
                Trace.trace(TRACE_MASKT, " LocationCodeStruce :: " + fspLocationCodeInfo.toString());
            }
            catch (Throwable throwable) {
                System.err.println("Throwable caught!!!!");
                throwable.printStackTrace();
                break;
            }
        }
        Trace.trace(TRACE_MASKT, "<- FspLocationCodeList._processStructures()");
    }
}

